﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class ClearRecentDocsOnExit : UserControl,IControl,ICorrespondenceOS
    {
        private ClearRecentDocsOnExitController clearRecentDocsOnExitController;

         public ClearRecentDocsOnExit()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,                              
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetClearRecentDocsOnExitState(bool b)
        {
            checkBox1.Checked = b;
        }


        public int GetClearRecentDocsOnExitState()
        {
            if (checkBox1.Checked)
            {
                return 1;
            }
            return 0;
        }

        #region IControl メンバ

        public void Apply()
        {
            clearRecentDocsOnExitController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return clearRecentDocsOnExitController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void ClearRecentDocsOnExit_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            clearRecentDocsOnExitController = new ClearRecentDocsOnExitController(this,
                                                                        (IClearRecentDocsOnExitStrategy)
                                                                        wfUtillity.
                                                                            GetCorrespondenceInstance
                                                                            (new List<ICorrespondenceOS>
                                                                                 {
                                                                                     new ClearRecentDocsOnExitDefaultStrategy()
                                                                                 }));
            clearRecentDocsOnExitController.Read();
        }
    }
}
